<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TipoEstadoSolicitud extends Model 
{

    protected $table = 'tipo_estados_solicitudes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name', 'final_state', 'previous_state_id');
    protected $visible = array('code', 'name', 'final_state', 'previous_state_id');

    public function previous_state()
    {
        return $this->belongsTo('TipoEstadoSolicitud', 'previous_state_id')->withTrashed();
    }

}